

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_color2 Red

extern int iPeriod = 15;
extern int iFullPeriods = 1;
double g_ibuf_84[];
double g_ibuf_88[];
bool gi_92;
int g_index_96;
int gia_100[30];

bool isDelimeter(int ai_0, int ai_4) {
   bool li_ret_8 = FALSE;
   switch (ai_0) {
   case 5:
      li_ret_8 = TimeMinute(Time[ai_4]) == 0;
      break;
   case 15:
      li_ret_8 = TimeMinute(Time[ai_4]) == 0;
      break;
   case 30:
      li_ret_8 = TimeMinute(Time[ai_4]) == 0 && MathMod(TimeHour(Time[ai_4]), 4.0) == 0.0;
      break;
   case 60:
      li_ret_8 = TimeMinute(Time[ai_4]) == 0 && MathMod(TimeHour(Time[ai_4]), 4.0) == 0.0;
      break;
   case 240:
      li_ret_8 = TimeMinute(Time[ai_4]) == 0 && TimeHour(Time[ai_4]) == 0;
      break;
   case 1440:
      li_ret_8 = TimeDayOfWeek(Time[ai_4]) == 1 && TimeHour(Time[ai_4]) == 0;
      break;
   case 10080:
      li_ret_8 = TimeDay(Time[ai_4]) == 1 || (TimeDay(Time[ai_4]) == 2 && TimeDay(Time[ai_4 + 1]) != 1) || (TimeDay(Time[ai_4]) == 3 && TimeDay(Time[ai_4 + 1]) != 2);
      break;
   default:
      Print("!!!!!!!!!!!!!!");
   }
   return (li_ret_8);
}

double AverageHigh(int ai_0) {
   double l_high_4;
   double ld_ret_12 = 0.0;
   int li_20 = ai_0;
   gi_92 = FALSE;
   for (g_index_96 = 0; g_index_96 < iPeriod + iFullPeriods; g_index_96++) {
      while (!isDelimeter(Period(), li_20)) li_20++;
      if (gi_92 == FALSE) gi_92 = li_20;
      gia_100[g_index_96] = li_20;
      li_20++;
   }
   li_20--;
   for (li_20 = iPeriod - 1; li_20 > 0; li_20--) {
      l_high_4 = High[iHighest(NULL, 0, MODE_HIGH, gia_100[li_20] - (gia_100[li_20 - 1]), gia_100[li_20 - 1] + 1)];
      ld_ret_12 += l_high_4;
   }
   if (iFullPeriods == 1) {
      l_high_4 = High[iHighest(NULL, 0, MODE_HIGH, gia_100[iPeriod] - (gia_100[iPeriod - 1]), gia_100[iPeriod - 1] + 1)];
      ld_ret_12 += l_high_4;
      ld_ret_12 /= NormalizeDouble(iPeriod, 0);
   } else {
      l_high_4 = High[iHighest(NULL, 0, MODE_HIGH, gia_100[0] - ai_0, ai_0)];
      ld_ret_12 += l_high_4;
      ld_ret_12 /= NormalizeDouble(iPeriod, 0);
   }
   return (ld_ret_12);
}

double AverageLow(int ai_0) {
   double l_low_4;
   double ld_ret_12 = 0.0;
   int li_20 = ai_0;
   gi_92 = FALSE;
   for (g_index_96 = 0; g_index_96 < iPeriod + iFullPeriods; g_index_96++) {
      while (!isDelimeter(Period(), li_20)) li_20++;
      if (gi_92 == FALSE) gi_92 = li_20;
      gia_100[g_index_96] = li_20;
      li_20++;
   }
   li_20--;
   for (li_20 = iPeriod - 1; li_20 > 0; li_20--) {
      l_low_4 = Low[iLowest(NULL, 0, MODE_LOW, gia_100[li_20] - (gia_100[li_20 - 1]), gia_100[li_20 - 1] + 1)];
      ld_ret_12 += l_low_4;
   }
   if (iFullPeriods == 1) {
      l_low_4 = Low[iLowest(NULL, 0, MODE_LOW, gia_100[iPeriod] - (gia_100[iPeriod - 1]), gia_100[iPeriod - 1] + 1)];
      ld_ret_12 += l_low_4;
      ld_ret_12 /= NormalizeDouble(iPeriod, 0);
   } else {
      l_low_4 = Low[iLowest(NULL, 0, MODE_LOW, gia_100[0] - ai_0, ai_0)];
      ld_ret_12 += l_low_4;
      ld_ret_12 /= NormalizeDouble(iPeriod, 0);
   }
   return (ld_ret_12);
}

int init() {
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexArrow(0, 233);
   SetIndexBuffer(0, g_ibuf_84);
   SetIndexEmptyValue(0, 0.0);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexArrow(1, 234);
   SetIndexBuffer(1, g_ibuf_88);
   SetIndexEmptyValue(1, 0.0);
   if (iFullPeriods != 0) iFullPeriods = 1;
   return (0);
}

int deinit() {
   return (0);
}

int start() {
   int li_0;
   int li_4;
   int l_ind_counted_8 = IndicatorCounted();
   if (Period() != PERIOD_W1) {
      if (l_ind_counted_8 < 0) return (-1);
      if (l_ind_counted_8 > 0) li_4 = Bars - l_ind_counted_8;
      if (l_ind_counted_8 == 0) {
         li_0 = Bars - 1;
         while (!isDelimeter(Period(), li_0)) li_0--;
         gi_92 = li_0;
         li_0--;
         for (g_index_96 = 0; g_index_96 < iPeriod; g_index_96++) {
            while (!isDelimeter(Period(), li_0)) li_0--;
            li_0--;
         }
         li_0++;
         li_4 = li_0;
      }
      for (int li_12 = li_4; li_12 >= 0; li_12--) {
         if (Close[li_12] > AverageHigh(li_12)) {
            g_ibuf_84[li_12] = AverageLow(li_12);
            g_ibuf_88[li_12] = 0.0;
         } else {
            if (Close[li_12] < AverageLow(li_12)) {
               g_ibuf_88[li_12] = AverageHigh(li_12);
               g_ibuf_84[li_12] = 0.0;
            } else {
               if (g_ibuf_88[li_12 + 1] != 0.0) g_ibuf_88[li_12] = AverageHigh(li_12);
               if (g_ibuf_84[li_12 + 1] != 0.0) g_ibuf_84[li_12] = AverageLow(li_12);
            }
         }
      }
      return (0);
   }
   return (0);
}